﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Excel = Microsoft.Office.Interop.Excel;

namespace ExcelEdycjaDanych
{
    public partial class Form1 : Form
    {
        Excel.Application xlApp;
        
        public Form1()
        {
            InitializeComponent();

            if (podlaczDoExcela())
            {
                xlApp.SheetSelectionChange +=
                    new Excel.AppEvents_SheetSelectionChangeEventHandler(
                        xlApp_SheetSelectionChange);
                xlApp.SheetChange += 
                    new Excel.AppEvents_SheetChangeEventHandler(xlApp_SheetChange);
            }
            else
                MessageBox.Show("Brak aktywnej instancji aplikacji MS Excel."
                    + "Obsługa zdarzeń nie będzie aktywna");
        }

        void xlApp_SheetSelectionChange(object Sh, Excel.Range Target)
        {
            textBox1.Text = Target.Value2;
            textBox2.Text = Target.Address;
        }

        void xlApp_SheetChange(object Sh, Excel.Range Target)
        {
            xlApp_SheetSelectionChange(Sh, Target);
        }

        bool podlaczDoExcela()
        {
            try
            {
                xlApp = (Excel.Application)System.Runtime.InteropServices.
                    Marshal.GetActiveObject("Excel.Application");

                return true;
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
                xlApp = null;
                return false;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (!podlaczDoExcela())
            {
                MessageBox.Show("Brak aktywnej instancji aplikacji MS Excel", this.Name);
                return;
            }
            
            Excel.Range aktywnaKomorka = xlApp.ActiveCell;
            textBox1.Text = aktywnaKomorka.Value2 == null ? 
                "Komórka jest pusta" : aktywnaKomorka.Value2.ToString();
            textBox2.Text = aktywnaKomorka.Address.ToString();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (!podlaczDoExcela())
            {
                MessageBox.Show("Brak aktywnej instancji aplikacji MS Excel", this.Name);
                return;
            }

            Excel.Range aktywnaKomorka = xlApp.ActiveCell;
            aktywnaKomorka.Value2 = textBox1.Text;
            textBox2.Text = aktywnaKomorka.Address;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (!podlaczDoExcela())
            {
                MessageBox.Show("Brak aktywnej instancji aplikacji MS Excel", this.Name);
                return;
            }

            Excel.Font font = xlApp.ActiveCell.Font;
            font.Bold = true;

            textBox2.Text = xlApp.ActiveCell.get_Address(0, 0, 
                Excel.XlReferenceStyle.xlR1C1).ToString();
        }
    }
}
